#include <linux/ioctl.h>
#include <stdio.h>
#include <sys/ioctl.h>
#include <sys/time.h>
#include <sys/types.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
//#include <errno.h>


#define XR_USB_SERIAL_IOC_MAGIC       	'v'

#define XR_USB_SERIAL_GET_REG           	_IOWR(XR_USB_SERIAL_IOC_MAGIC, 1, int)
#define XR_USB_SERIAL_SET_REG           	_IOWR(XR_USB_SERIAL_IOC_MAGIC, 2, int)
#define XR_USB_SERIAL_SET_ADDRESS_MATCH 	_IO(XR_USB_SERIAL_IOC_MAGIC, 3)
#define XR_USB_SERIAL_SET_PRECISE_FLAGS     	_IO(XR_USB_SERIAL_IOC_MAGIC, 4)
#define XR_USB_SERIAL_TEST_MODE         	_IO(XR_USB_SERIAL_IOC_MAGIC, 5)
#define XR_USB_SERIAL_LOOPBACK          	_IO(XR_USB_SERIAL_IOC_MAGIC, 6)
#define XR_USB_SERIAL_SET_GPIO_MODE_REG    _IO(XR_USB_SERIAL_IOC_MAGIC, 9) 
#define XR_USB_SERIAL_GET_GPIO_MODE_REG    _IO(XR_USB_SERIAL_IOC_MAGIC, 10) 
#define XRIOC_SET_ANY_BAUD_RATE           _IO(XR_USB_SERIAL_IOC_MAGIC, 11)
#define XRIOC_SET_PRECISE_FLAGS     	   _IO(XR_USB_SERIAL_IOC_MAGIC, 12)

#define XR_USB_SERIAL_CH0_OPEN            _IOWR(XR_USB_SERIAL_IOC_MAGIC, 7, int)
#define XR_USB_SERIAL_CH1_OPEN            _IOWR(XR_USB_SERIAL_IOC_MAGIC, 8, int)
#define TEST_PUT_USER                 	  _IOWR(XR_USB_SERIAL_IOC_MAGIC, 13, int)
#define SET_REG_ADDR               	_IOWR(XR_USB_SERIAL_IOC_MAGIC, 14, int)
#define MODULE_GET_CH2_REG               	_IOWR(XR_USB_SERIAL_IOC_MAGIC, 15, int)
#define MODULE_SET_CH2_REG               	_IOWR(XR_USB_SERIAL_IOC_MAGIC, 16, int)
#define XR_USB_SERIAL_CHANNEL_INIT      _IOWR(XR_USB_SERIAL_IOC_MAGIC, 17, int)

#define VZ_ADDRESS_UNICAST_S        	0
#define VZ_ADDRESS_BROADCAST_S      	8
#define VZ_ADDRESS_MATCH(U, B)          (0x8000000 | ((B) << VZ_ADDRESS_BROADCAST_S) | ((U) << VZ_ADDRESS_UNICAST_S))
#define VZ_ADDRESS_MATCH_DISABLE    	0

#define CHANNEL0                        0
#define CHANNEL1                        1
#define GET_CH0_REG                     2
#define SET_CH0_REG                     3
#define GET_CH2_REG                     4
#define SET_CH2_REG                     5
#define GET_STATUS                      6
#define DRAWER_INITIAL                  7

void usage(void);

int main(int argc, char *argv[])
{
    int devfd, result;
    long int arg;
    long int addr, get_val, val;
    int opt, channel;
    int state;
    
    char get[] = "get";
    char set[] = "set";
    char cstate[] = "state"; 
    char initial[] = "init";
    char cda[] = "cda";
    char cdb[] = "cdb";

    if((argc != 2 && argc != 4 && argc != 5) || *argv[1] == 'h'){
        printf("Segment fault...\n");
        usage();
        return 0;
    }else if(argc == 2){
        printf("Channel control mode.");
        if(strncmp(argv[1], cda, 3) == 0){//if(*argv[1] == 'A'){
            printf("\nSelect channel %s.\n", argv[1]);
            opt = CHANNEL0;
        }else if(strncmp(argv[1], cdb, 3) == 0){//if(*argv[1] == 'B'){
            printf("\nSelect channel %s.\n", argv[1]);
            opt = CHANNEL1;
        }else if(strncmp(argv[1], cstate, 5) == 0){
            printf("\nCash drawer is ");
            opt = GET_STATUS;
        }else if(strncmp(argv[1], initial, 4) == 0){
            printf("\nCash drawer initial.\n");
            opt = DRAWER_INITIAL;
        }else{
            printf("Invalid option, exit...\n");
            printf("[Usage] $ ./drawer [option:cda or cdb or state or init]\n\n");
            return 0;
        }
    }else if(argc == 4){
        if(strncmp(argv[1], get, 3) == 0){
            printf("Get Register mode.\n");
            channel = atoi(argv[2]);
            if(channel == 0){
                opt = GET_CH0_REG;
            }else if(channel == 2){
                opt = GET_CH2_REG;
            }else{
                printf("Invalid args, exit...\n");
                printf("[Usage] $ ./drawer [opt] [channel_NO:0 or 2] [addr]\n\n");
                return 0;                
            }           
        }else{
            printf("Segment fault...\n\n");
            usage();
        }
        //addr = atoi(argv[3]);
        addr = strtol(argv[3], NULL, 16);
        get_val = addr; //trans addr to kernal, then get return value from kernel
    }else if(argc == 5){
        if(strncmp(argv[1], set, 3) == 0){
            printf("Set Register mode.");
            channel = atoi(argv[2]);
            if(channel == 0){
                opt = SET_CH0_REG; 
            }else if(channel == 2){
                opt = SET_CH2_REG; 
            }else{
                printf("Invalid args, exit...\n");
                printf("[Usage] $ ./drawer [opt] [channel_NO:0 or 2] [addr] [value]\n\n");
                return 0; 
            }
        }else{
            printf("Segment fault...\n\n");
            usage();
        }
        //addr = atoi(argv[3]);
        //val = atoi(argv[4]);
        addr = strtol(argv[3], NULL, 16);
        val = strtol(argv[4], NULL, 16);
    }

    devfd = open("/dev/ttyXRUSB0", O_RDWR);
    if (devfd == -1){
        printf("Can't open /dev/ttyXRUSB0\n");
        return -1;
    }
    switch(opt){
        case CHANNEL0:
            result = ioctl(devfd, XR_USB_SERIAL_CH0_OPEN, &opt);
            break;

        case CHANNEL1:
            result = ioctl(devfd, XR_USB_SERIAL_CH1_OPEN, &opt);
            break;
        case GET_CH0_REG:
            result = ioctl(devfd, TEST_PUT_USER, &get_val);
            printf("Get ch0 reg:0x%0lx, value:0x%0lx\n", addr, get_val);
            break;
        case SET_CH0_REG:
            arg = (addr*10000) + val;
            printf(" arg:0x%0lx\n", arg);
            result = ioctl(devfd, SET_REG_ADDR, &arg);
            printf("Set ch0 reg:0x%0lx, value:0x%0lx\n", addr, val);
            break;
        case GET_CH2_REG:
            result = ioctl(devfd, MODULE_GET_CH2_REG, &get_val);
            printf("Get ch2 reg:0x%0lx, value:0x%0lx\n", addr, get_val);
            break;
        case SET_CH2_REG:
            arg = (addr*10000) + val;
            printf(" arg:0x%0lx\n", arg);
            result = ioctl(devfd, MODULE_SET_CH2_REG, &arg);
            printf("Set ch2 reg:0x%0lx, value:0x%0lx\n", addr, val);
            break;
        case GET_STATUS:
            get_val = 0x10;
            result = ioctl(devfd, TEST_PUT_USER, &get_val);
            state = (get_val&0x200)>>9;
            if(state == 1){
                printf("\E[1;32;10m"); //color:green
                printf("open");
                printf("\E[0m");
                printf(".\n");
                printf("reg value:0x%0lx, state:0x%0x\n\n", get_val, state);
            }else if(state == 0){
                printf("\E[1;31;10m"); //color:red
                printf("close");
                printf("\E[0m");
                printf(".\n");
                printf("reg value:0x%0lx, state:0x%0x\n\n", get_val, state);
            }else{
                printf("undefine state...\n");
            }
            break;
        case DRAWER_INITIAL:
            result = ioctl(devfd, XR_USB_SERIAL_CHANNEL_INIT, &opt);
            sleep(1);
            result = ioctl(devfd, XR_USB_SERIAL_CH0_OPEN, &opt);
            sleep(1);
            result = ioctl(devfd, XR_USB_SERIAL_CH1_OPEN, &opt);
            sleep(1);
            result = ioctl(devfd, XR_USB_SERIAL_CHANNEL_INIT, &opt);
            sleep(1);
            result = ioctl(devfd, XR_USB_SERIAL_CH0_OPEN, &opt);
            sleep(1);
            result = ioctl(devfd, XR_USB_SERIAL_CH1_OPEN, &opt);
            sleep(1);
            result = ioctl(devfd, XR_USB_SERIAL_CHANNEL_INIT, &opt);
            break;        
        default:
            break;
    }

    close(devfd);
    return 0;
}

void usage(void)
{
    printf("\n");
    printf("[CMD Usage] #./drawer [option] [channel] [arg1] [arg2]...\n");
    printf("    [option] initial Cash drawer, set init\n");
    printf("    [option] channel control, select cash drawer= cda or cdb\n");
    printf("    [option] get current status, set channel= state\n");
    printf("    [option] Get register, option=get\n");
    printf("    [option] Set register, option=set\n");
    printf("        [channel] for Get or Set function, channel select 0 or 2\n");
    printf("            [arg1] Get register, arg1=[addr]\n");
    printf("            [arg1] Set register, arg1=[addr]\n");
    printf("            [arg2] Set register, arg2=[value]\n\n");
    printf("[EXAMPLE]\n");
    printf("    1. Initial cash drawer : #./drawer init\n");
    printf("    2. Control cash drawer a : #./drawer cda\n");
    printf("    3. Get channle 0 reg=0x0D : #./drawer get 0 0x0D\n");
    printf("    4. Set channle 0 reg=0x0D value=0x256: #./drawer set 0 0x0D 0x256\n\n\n");
}



